//GEMINI-pro DATASET v1.0 Category: Building a SMTP Client ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>

void send_email(char *from, char *to, char *subject, char *message) {
  int sockfd;
  struct sockaddr_in servaddr;

  // Create a TCP socket
  sockfd = socket(AF_INET, SOCK_STREAM, 0);

  // Initialize the server address
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons(25); // SMTP port
  servaddr.sin_addr.s_addr = inet_addr("127.0.0.1"); // localhost

  // Connect to the server
  if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
    perror("connect failed");
    exit(1);
  }

  // Read the server's greeting
  char buffer[1024];
  memset(buffer, 0, sizeof(buffer));
  if (read(sockfd, buffer, sizeof(buffer)) < 0) {
    perror("read failed");
    exit(1);
  }

  // Send the HELO command
  memset(buffer, 0, sizeof(buffer));
  sprintf(buffer, "HELO %s\r\n", "localhost");
  if (write(sockfd, buffer, strlen(buffer)) < 0) {
    perror("write failed");
    exit(1);
  }

  // Read the server's response to the HELO command
  memset(buffer, 0, sizeof(buffer));
  if (read(sockfd, buffer, sizeof(buffer)) < 0) {
    perror("read failed");
    exit(1);
  }

  // Send the MAIL FROM command
  memset(buffer, 0, sizeof(buffer));
  sprintf(buffer, "MAIL FROM: <%s>\r\n", from);
  if (write(sockfd, buffer, strlen(buffer)) < 0) {
    perror("write failed");
    exit(1);
  }

  // Read the server's response to the MAIL FROM command
  memset(buffer, 0, sizeof(buffer));
  if (read(sockfd, buffer, sizeof(buffer)) < 0) {
    perror("read failed");
    exit(1);
  }

  // Send the RCPT TO command
  memset(buffer, 0, sizeof(buffer));
  sprintf(buffer, "RCPT TO: <%s>\r\n", to);
  if (write(sockfd, buffer, strlen(buffer)) < 0) {
    perror("write failed");
    exit(1);
  }

  // Read the server's response to the RCPT TO command
  memset(buffer, 0, sizeof(buffer));
  if (read(sockfd, buffer, sizeof(buffer)) < 0) {
    perror("read failed");
    exit(1);
  }

  // Send the DATA command
  memset(buffer, 0, sizeof(buffer));
  sprintf(buffer, "DATA\r\n");
  if (write(sockfd, buffer, strlen(buffer)) < 0) {
    perror("write failed");
    exit(1);
  }

  // Read the server's response to the DATA command
  memset(buffer, 0, sizeof(buffer));
  if (read(sockfd, buffer, sizeof(buffer)) < 0) {
    perror("read failed");
    exit(1);
  }

  // Send the email message
  // Note: The email message should end with a CRLF.CRLF sequence
  memset(buffer, 0, sizeof(buffer));
  sprintf(buffer, "From: %s\r\nTo: %s\r\nSubject: %s\r\n\r\n%s\r\n.\r\n", from, to, subject, message);
  if (write(sockfd, buffer, strlen(buffer)) < 0) {
    perror("write failed");
    exit(1);
  }

  // Read the server's response to the email message
  memset(buffer, 0, sizeof(buffer));
  if (read(sockfd, buffer, sizeof(buffer)) < 0) {
    perror("read failed");
    exit(1);
  }

  // Send the QUIT command
  memset(buffer, 0, sizeof(buffer));
  sprintf(buffer, "QUIT\r\n");
  if (write(sockfd, buffer, strlen(buffer)) < 0) {
    perror("write failed");
    exit(1);
  }

  // Read the server's response to the QUIT command
  memset(buffer, 0, sizeof(buffer));
  if (read(sockfd, buffer, sizeof(buffer)) < 0) {
    perror("read failed");
    exit(1);
  }

  // Close the socket
  close(sockfd);
}

int main(int argc, char **argv) {
  if (argc != 6) {
    fprintf(stderr, "Usage: %s <from> <to> <subject> <message>\n", argv[0]);
    exit(1);
  }

  send_email(argv[1], argv[2], argv[3], argv[4]);

  return 0;
}