//Falcon-180B DATASET v1.0 Category: Queue Implementation ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>

#define MAX_QUEUE_SIZE 10

typedef struct {
    int data;
    int priority;
} QueueItem;

typedef struct {
    QueueItem items[MAX_QUEUE_SIZE];
    int front;
    int rear;
} Queue;

void initQueue(Queue* q) {
    q->front = -1;
    q->rear = -1;
}

int isEmpty(Queue* q) {
    return q->front == -1 && q->rear == -1;
}

int isFull(Queue* q) {
    return q->rear == MAX_QUEUE_SIZE - 1;
}

void enqueue(Queue* q, int data, int priority) {
    if (isFull(q)) {
        printf("Error: Queue is full.\n");
        return;
    }
    if (isEmpty(q)) {
        q->front = q->rear = 0;
    } else {
        q->rear++;
    }
    q->items[q->rear].data = data;
    q->items[q->rear].priority = priority;
}

int dequeue(Queue* q) {
    if (isEmpty(q)) {
        printf("Error: Queue is empty.\n");
        return -1;
    }
    int data = q->items[q->front].data;
    int priority = q->items[q->front].priority;
    if (q->front == q->rear) {
        q->front = q->rear = -1;
    } else {
        q->front++;
    }
    return data;
}

int main() {
    Queue q;
    initQueue(&q);
    enqueue(&q, 1, 10);
    enqueue(&q, 2, 20);
    enqueue(&q, 3, 30);
    enqueue(&q, 4, 40);
    enqueue(&q, 5, 50);
    printf("Dequeued item: %d\n", dequeue(&q));
    printf("Dequeued item: %d\n", dequeue(&q));
    printf("Dequeued item: %d\n", dequeue(&q));
    printf("Dequeued item: %d\n", dequeue(&q));
    printf("Dequeued item: %d\n", dequeue(&q));
    printf("Dequeued item: %d\n", dequeue(&q));
    return 0;
}