//GEMINI-pro DATASET v1.0 Category: Memory management ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 1024

typedef struct {
    int size;
    char *data;
} buffer_t;

buffer_t *buffer_create(int size) {
    buffer_t *buffer = malloc(sizeof(buffer_t));
    if (buffer == NULL) {
        return NULL;
    }

    buffer->size = size;
    buffer->data = malloc(size);
    if (buffer->data == NULL) {
        free(buffer);
        return NULL;
    }

    return buffer;
}

void buffer_destroy(buffer_t *buffer) {
    free(buffer->data);
    free(buffer);
}

int buffer_write(buffer_t *buffer, const char *data, int size) {
    if (size > buffer->size) {
        return -1;
    }

    memcpy(buffer->data, data, size);
    return size;
}

int buffer_read(buffer_t *buffer, char *data, int size) {
    if (size > buffer->size) {
        return -1;
    }

    memcpy(data, buffer->data, size);
    return size;
}

int main() {
    buffer_t *buffer = buffer_create(MAX_SIZE);
    if (buffer == NULL) {
        return -1;
    }

    const char *data = "Hello, world!";
    int size = strlen(data) + 1;

    int written = buffer_write(buffer, data, size);
    if (written != size) {
        return -1;
    }

    char out[MAX_SIZE];
    int read = buffer_read(buffer, out, size);
    if (read != size) {
        return -1;
    }

    out[read] = '\0';
    printf("%s\n", out);

    buffer_destroy(buffer);
    return 0;
}