//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Function to display a success message
void display_success(const char *message) {
    printf("\n😊 %s 🎉\n", message);
}

// Function to display a failure message
void display_failure(const char *message) {
    fprintf(stderr, "\n😢 %s 😞\n", message);
}

// Callback function to display retrieved rows
static int callback(void *data, int argc, char **argv, char **azColName) {
    printf("🌟 User Info 🌟\n");
    for (int i = 0; i < argc; i++) {
        printf("%s: %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("----------------------\n");
    return 0;
}

int main(int argc, char* argv[]) {
    sqlite3 *db;
    char *err_msg = 0;
    int rc;

    // Open the database
    rc = sqlite3_open("happy_users.db", &db);

    if (rc != SQLITE_OK) {
        display_failure("Cannot open database");
        return 1;
    }
    display_success("Connected to the database! 😊");

    // SQL query to retrieve all happy users
    const char *sql = "SELECT * FROM happy_users;";

    // Execute SQL statement
    rc = sqlite3_exec(db, sql, callback, 0, &err_msg);

    if (rc != SQLITE_OK) {
        display_failure(err_msg);
        sqlite3_free(err_msg);
    } else {
        display_success("Query executed successfully! 🎊");
    }

    // Close the database
    sqlite3_close(db);
    display_success("Database connection closed. 🌈");

    return 0;
}