//GPT-4o-mini DATASET v1.0 Category: Building a JSON Parser ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_JSON_SIZE 1024
#define MAX_TOKEN_SIZE 256

typedef struct {
    char key[MAX_TOKEN_SIZE];
    char value[MAX_TOKEN_SIZE];
} KeyValuePair;

// Function prototypes
void skipWhitespace(char **json);
int parseString(char **json, char *buffer);
int parseKeyValuePair(char **json, KeyValuePair *kvPair);
int parseJSON(char *json, KeyValuePair *kvPairs, int *count);
void printKeyValuePairs(KeyValuePair *kvPairs, int count);

int main() {
    // Sample JSON object for parsing
    char json[MAX_JSON_SIZE] = "{\"name\":\"Wastelander\",\"age\":\"17\",\"weapon\":\"Crossbow\"}";
    
    KeyValuePair kvPairs[MAX_JSON_SIZE / 2]; // Let's assume 2 key-value pairs at most per JSON object
    int count = 0;
    
    if (parseJSON(json, kvPairs, &count)) {
        printKeyValuePairs(kvPairs, count);
    } else {
        printf("Failed to parse the JSON data in this forsaken world.\n");
    }

    return 0;
}

// Function to skip whitespace in the JSON string
void skipWhitespace(char **json) {
    while (isspace(**json)) {
        (*json)++;
    }
}

// Function to parse a string from JSON
int parseString(char **json, char *buffer) {
    if (**json != '"') return 0; // Not a string
    
    (*json)++; // Skip the opening quote
    char *start = buffer;
    
    while (**json && **json != '"') {
        *start++ = **json;
        (*json)++;
    }
    *start = '\0'; // Null-terminate the string
    
    if (**json == '"') {
        (*json)++; // Skip the closing quote
        return 1;
    }
    
    return 0; // No closing quote found
}

// Function to parse a key-value pair from JSON
int parseKeyValuePair(char **json, KeyValuePair *kvPair) {
    skipWhitespace(json);
    if (!parseString(json, kvPair->key)) return 0;

    skipWhitespace(json);
    if (**json != ':') return 0;
    
    (*json)++; // Skip the colon
    skipWhitespace(json);
    
    return parseString(json, kvPair->value);
}

// Function to parse the full JSON object
int parseJSON(char *json, KeyValuePair *kvPairs, int *count) {
    char *ptr = json;
    
    skipWhitespace(&ptr);
    if (*ptr != '{') return 0;
    ptr++; // Skip the opening brace
    
    while (*ptr) {
        skipWhitespace(&ptr);
        if (*ptr == '}') break;

        if (!parseKeyValuePair(&ptr, &kvPairs[*count])) return 0;
        (*count)++;

        skipWhitespace(&ptr);
        if (*ptr == ',') ptr++; // Skip the comma
    }
    
    return 1;
}

// Function to print the parsed key-value pairs
void printKeyValuePairs(KeyValuePair *kvPairs, int count) {
    printf("The remnants of JSON data found in the apocalypse:\n");
    for (int i = 0; i < count; i++) {
        printf("Key: %s, Value: %s\n", kvPairs[i].key, kvPairs[i].value);
    }
}