//Falcon2-11B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BAGS 10
#define BAG_SIZE 30

// Define a struct to represent a bag
typedef struct {
    char bag[BAG_SIZE];
    char type[BAG_SIZE];
} Bag;

// Function to add a bag to the baggage area
void add_bag(Bag* bags, int size, char* bag_type) {
    // Check if bag is valid
    if (strlen(bag_type) < BAG_SIZE) {
        printf("Bag is valid\n");
    } else {
        printf("Invalid bag type\n");
        return;
    }

    // Check if baggage area is full
    if (size >= MAX_BAGS) {
        printf("Baggage area is full\n");
        return;
    }

    // Add bag to the baggage area
    strcpy(bags[size].bag, bag_type);
    strcpy(bags[size].type, "Airport Baggage Handling");

    printf("Bag added to baggage area\n");
}

// Function to remove a bag from the baggage area
void remove_bag(Bag* bags, int size, char* bag_type) {
    // Check if bag is valid
    if (strlen(bag_type) < BAG_SIZE) {
        printf("Bag is valid\n");
    } else {
        printf("Invalid bag type\n");
        return;
    }

    // Check if there are any bags in the baggage area
    if (size > 0) {
        printf("Bag removed from baggage area\n");
        strcpy(bags[size - 1].bag, "");
        strcpy(bags[size - 1].type, "");
    } else {
        printf("No bags in baggage area\n");
    }
}

// Function to get the status of the baggage area
void get_status(Bag* bags, int size) {
    if (size == 0) {
        printf("Baggage area is empty\n");
        return;
    }

    printf("Baggage area has %d bags:\n", size);
    for (int i = 0; i < size; i++) {
        printf("%s - %s\n", bags[i].bag, bags[i].type);
    }
}

int main() {
    Bag bags[MAX_BAGS];

    // Initialize the baggage area
    for (int i = 0; i < MAX_BAGS; i++) {
        strcpy(bags[i].bag, "");
        strcpy(bags[i].type, "");
    }

    // Get the status of the baggage area
    get_status(bags, MAX_BAGS);

    return 0;
}