//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define WIDTH 40
#define HEIGHT 20

void drawSquare(int x, int y, int size, char canvas[HEIGHT][WIDTH]) {
    if (size <= 0) return; // Base case

    for (int i = 0; i < size; i++) {
        for (int j = 0; j < size; j++) {
            if (x + i < HEIGHT && y + j < WIDTH) {
                canvas[x + i][y + j] = '#'; // Set character for pixel
            }
        }
    }
    // Recursive call for a smaller square
    drawSquare(x + size, y + size, size / 2, canvas);
}

void drawTriangle(int x, int y, int size, char canvas[HEIGHT][WIDTH]) {
    if (size <= 0) return; // Base case

    for (int i = 0; i < size; i++) {
        for (int j = 0; j <= i; j++) {
            if (x + i < HEIGHT && y + j < WIDTH) {
                canvas[x + i][y + j] = '*'; // Set character for pixel
            }
        }
    }
    // Recursive call for a smaller triangle
    drawTriangle(x + size, y, size / 2, canvas);
}

void clearCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            canvas[i][j] = ' '; // Clear the canvas
        }
    }
}

void printCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            putchar(canvas[i][j]);
        }
        putchar('\n');
    }
}

int main() {
    char canvas[HEIGHT][WIDTH];
    clearCanvas(canvas);

    // Generate pixel art
    drawSquare(0, 0, 8, canvas);   // Draw square
    drawTriangle(10, 0, 6, canvas); // Draw triangle

    // Display the pixel art
    printCanvas(canvas);

    return 0;
}