//Falcon-180B DATASET v1.0 Category: Network Quality of Service (QoS) monitor ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <sys/time.h>
#include <time.h>

#define MAX_SIZE 1024
#define SERVER_PORT 8080
#define SERVER_IP "127.0.0.1"

int sockfd;
struct sockaddr_in server_addr;
int opt = 1;
char buffer[MAX_SIZE];

void error_handling(char *message) {
    perror(message);
    exit(0);
}

int create_socket() {
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        error_handling("socket failed");
    }
    if (setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))) {
        error_handling("setsockopt");
    }
    return sockfd;
}

int connect_to_server() {
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = inet_addr(SERVER_IP);
    server_addr.sin_port = htons(SERVER_PORT);

    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        error_handling("connect");
    }
    return 0;
}

int send_data(char *data) {
    if (send(sockfd, data, strlen(data), 0) < 0) {
        error_handling("send");
    }
    return 0;
}

int receive_data(char *data) {
    if (recv(sockfd, data, MAX_SIZE, 0) < 0) {
        error_handling("recv");
    }
    return 0;
}

int main() {
    sockfd = create_socket();
    connect_to_server();

    char *message = "Hello, World!";
    send_data(message);

    char response[MAX_SIZE];
    receive_data(response);

    printf("Response from server: %s\n", response);

    close(sockfd);
    return 0;
}