//Falcon-180B DATASET v1.0 Category: Performance-Critical Component ; Style: medieval
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 100

typedef struct {
    char name[20];
    int quantity;
    float price;
} Item;

void add_item(Item* inventory, int n, const char* name, int quantity, float price) {
    if (n >= MAX_ITEMS) {
        printf("Thy inventory is full, thou canst not add more items.\n");
        return;
    }

    strcpy(inventory[n].name, name);
    inventory[n].quantity = quantity;
    inventory[n].price = price;

    printf("Item added: %s (%d in stock) - %.2f gold coins each\n",
           inventory[n].name, inventory[n].quantity, inventory[n].price);
}

void remove_item(Item* inventory, int n, int quantity) {
    if (n >= MAX_ITEMS || inventory[n].quantity < quantity) {
        printf("Thou dost not have enough of that item in thy inventory.\n");
        return;
    }

    inventory[n].quantity -= quantity;

    printf("Item removed: %s (%d left in stock)\n", inventory[n].name, inventory[n].quantity);
}

void display_inventory(Item* inventory, int n) {
    printf("Thy current inventory:\n");
    for (int i = 0; i < n; i++) {
        printf("%s (%d in stock) - %.2f gold coins each\n",
               inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

int main() {
    Item inventory[MAX_ITEMS];
    int n = 0;

    add_item(inventory, n, "Sword", 10, 50.0);
    add_item(inventory, n, "Shield", 5, 20.0);

    display_inventory(inventory, n);

    remove_item(inventory, n, 3);

    display_inventory(inventory, n);

    return 0;
}