//GEMINI-pro DATASET v1.0 Category: Online Examination System ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Student structure to store student data
typedef struct student {
    char name[50];
    int marks[10];
    float average;
} student;

// Function to calculate average marks of a student
float calculateAverage(student *s) {
    float sum = 0;
    for (int i = 0; i < 10; i++) {
        sum += s->marks[i];
    }
    return sum / 10;
}

// Function to compare two students based on their average marks
int compareStudents(const void *a, const void *b) {
    student *s1 = (student *)a;
    student *s2 = (student *)b;
    return s1->average - s2->average;
}

// Main function
int main() {
    // Initialize an array of students
    student students[5] = {
        {"John Doe", {90, 85, 95, 88, 92, 94, 93, 91, 92, 90}},
        {"Jane Doe", {95, 90, 93, 92, 94, 95, 93, 91, 92, 94}},
        {"Mark Smith", {85, 88, 90, 87, 89, 90, 88, 86, 87, 88}},
        {"Mary Jones", {92, 94, 95, 93, 94, 96, 94, 92, 93, 94}},
        {"Tom Brown", {88, 89, 90, 87, 89, 88, 86, 87, 89, 88}}
    };

    // Calculate average marks for each student
    for (int i = 0; i < 5; i++) {
        students[i].average = calculateAverage(&students[i]);
    }

    // Sort the students based on their average marks
    qsort(students, 5, sizeof(student), compareStudents);

    // Print the sorted list of students
    printf("Sorted list of students based on average marks:\n\n");
    for (int i = 0; i < 5; i++) {
        printf("%s: %.2f\n", students[i].name, students[i].average);
    }

    return 0;
}