//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: invasive
// Welcome to the Product Inventory System!

// Let's start with some essentials
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Our inventory record structure
typedef struct {
  char name[50];
  float price;
  int quantity;
} InventoryItem;

// Our global inventory database
InventoryItem inventory[100];

// The number of items in our inventory
int inventoryCount = 0;

// Function to add a new item to the inventory
void addItem(char *name, float price, int quantity) {
  strcpy(inventory[inventoryCount].name, name);
  inventory[inventoryCount].price = price;
  inventory[inventoryCount].quantity = quantity;
  inventoryCount++;
}

// Function to remove an item from the inventory
void removeItem(char *name) {
  for (int i = 0; i < inventoryCount; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      // Found the item, so let's remove it
      for (int j = i; j < inventoryCount - 1; j++) {
        inventory[j] = inventory[j + 1];
      }
      inventoryCount--;
      break;
    }
  }
}

// Function to update an item in the inventory
void updateItem(char *name, float price, int quantity) {
  for (int i = 0; i < inventoryCount; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      // Found the item, so let's update it
      inventory[i].price = price;
      inventory[i].quantity = quantity;
      break;
    }
  }
}

// Function to print the inventory
void printInventory() {
  printf("\nOur inventory contains:\n");
  printf("------------------------\n");
  for (int i = 0; i < inventoryCount; i++) {
    printf("Name: %s\n", inventory[i].name);
    printf("Price: %.2f\n", inventory[i].price);
    printf("Quantity: %d\n", inventory[i].quantity);
    printf("\n");
  }
}

// **Caution!** The main function is a labyrinth of madness. Enter at your own peril.
int main() {
  // Let's add some items to our inventory
  addItem("Apple", 0.50, 100);
  addItem("Banana", 0.75, 75);
  addItem("Orange", 1.00, 50);

  // Time to remove an item from the inventory
  removeItem("Banana");

  // Let's update an item in the inventory
  updateItem("Apple", 0.70, 150);

  // Now, let's print our inventory to the console
  printInventory();

  return 0;
}