//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SUBSCRIBERS 1000
#define MAX_EMAIL_LENGTH 100
#define MAX_NAME_LENGTH 50

// Subscriber structure
typedef struct {
    char name[MAX_NAME_LENGTH];
    char email[MAX_EMAIL_LENGTH];
} Subscriber;

// Function prototypes
void addSubscriber(Subscriber* subscribers, int numSubscribers, char* name, char* email);
void removeSubscriber(Subscriber* subscribers, int numSubscribers, char* email);
void sendEmail(Subscriber* subscribers, int numSubscribers, char* subject, char* body);

int main() {
    Subscriber subscribers[MAX_SUBSCRIBERS];
    int numSubscribers = 0;

    // Add some subscribers
    addSubscriber(subscribers, numSubscribers, "John Doe", "john.doe@example.com");
    addSubscriber(subscribers, numSubscribers, "Jane Doe", "jane.doe@example.com");

    // Remove a subscriber
    removeSubscriber(subscribers, numSubscribers, "john.doe@example.com");

    // Send an email to all subscribers
    sendEmail(subscribers, numSubscribers, "Hello World!", "This is a test email.");

    return 0;
}

void addSubscriber(Subscriber* subscribers, int numSubscribers, char* name, char* email) {
    if (numSubscribers >= MAX_SUBSCRIBERS) {
        printf("Error: Maximum number of subscribers reached.\n");
        return;
    }

    strcpy(subscribers[numSubscribers].name, name);
    strcpy(subscribers[numSubscribers].email, email);

    numSubscribers++;
}

void removeSubscriber(Subscriber* subscribers, int numSubscribers, char* email) {
    int i;

    for (i = 0; i < numSubscribers; i++) {
        if (strcmp(subscribers[i].email, email) == 0) {
            memmove(&subscribers[i], &subscribers[i+1], (numSubscribers - i - 1) * sizeof(Subscriber));
            numSubscribers--;
            return;
        }
    }

    printf("Error: Subscriber not found.\n");
}

void sendEmail(Subscriber* subscribers, int numSubscribers, char* subject, char* body) {
    int i;

    printf("Sending email to %d subscribers...\n", numSubscribers);

    for (i = 0; i < numSubscribers; i++) {
        printf("Sending email to %s <%s>...\n", subscribers[i].name, subscribers[i].email);
    }
}