//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define NUM_THREADS 5

typedef struct {
    int thread_id;
    int sleep_time;
} ThreadData;

void* threadFunction(void* arg);
void initializeThreads(pthread_t* threads, ThreadData* threadData);
void joinThreads(pthread_t* threads);

int main() {
    pthread_t threads[NUM_THREADS];
    ThreadData threadData[NUM_THREADS];

    initializeThreads(threads, threadData);
    joinThreads(threads);

    return 0;
}

void initializeThreads(pthread_t* threads, ThreadData* threadData) {
    for(int i = 0; i < NUM_THREADS; i++) {
        threadData[i].thread_id = i + 1;
        threadData[i].sleep_time = rand() % 5 + 1; // Random sleep time between 1 and 5 seconds

        if(pthread_create(&threads[i], NULL, threadFunction, (void *)&threadData[i]) != 0) {
            fprintf(stderr, "Error creating thread %d\n", i);
            exit(EXIT_FAILURE);
        }
    }
}

void* threadFunction(void* arg) {
    ThreadData* data = (ThreadData*)arg;
    printf("Thread %d: Sleeping for %d seconds...\n", data->thread_id, data->sleep_time);
    sleep(data->sleep_time);
    printf("Thread %d: Finished sleeping.\n", data->thread_id);
    pthread_exit(NULL);
}

void joinThreads(pthread_t* threads) {
    for(int i = 0; i < NUM_THREADS; i++) {
        if(pthread_join(threads[i], NULL) != 0) {
            fprintf(stderr, "Error joining thread %d\n", i);
            exit(EXIT_FAILURE);
        }
    }
}