//GEMINI-pro DATASET v1.0 Category: Matrix operations ; Style: surprised
#include <stdio.h>
#include <stdlib.h>

// Matrix size
#define N 3

// Function to add two matrices
void addMatrices(int A[][N], int B[][N], int C[][N]) {
  int i, j;

  for (i = 0; i < N; i++) {
    for (j = 0; j < N; j++) {
      C[i][j] = A[i][j] + B[i][j];
    }
  }
}

// Function to subtract two matrices
void subtractMatrices(int A[][N], int B[][N], int C[][N]) {
  int i, j;

  for (i = 0; i < N; i++) {
    for (j = 0; j < N; j++) {
      C[i][j] = A[i][j] - B[i][j];
    }
  }
}

// Function to multiply two matrices
void multiplyMatrices(int A[][N], int B[][N], int C[][N]) {
  int i, j, k;

  for (i = 0; i < N; i++) {
    for (j = 0; j < N; j++) {
      C[i][j] = 0;
      for (k = 0; k < N; k++) {
        C[i][j] += A[i][k] * B[k][j];
      }
    }
  }
}

// Function to print a matrix
void printMatrix(int A[][N]) {
  int i, j;

  for (i = 0; i < N; i++) {
    for (j = 0; j < N; j++) {
      printf("%d ", A[i][j]);
    }
    printf("\n");
  }
}

int main() {
  // Initialize three matrices
  int A[N][N] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
  int B[N][N] = {{9, 8, 7}, {6, 5, 4}, {3, 2, 1}};
  int C[N][N];

  // Add the two matrices
  addMatrices(A, B, C);

  // Print the resulting matrix
  printf("Sum of the two matrices:\n");
  printMatrix(C);

  // Subtract the two matrices
  subtractMatrices(A, B, C);

  // Print the resulting matrix
  printf("Difference of the two matrices:\n");
  printMatrix(C);

  // Multiply the two matrices
  multiplyMatrices(A, B, C);

  // Print the resulting matrix
  printf("Product of the two matrices:\n");
  printMatrix(C);

  return 0;
}