//GPT-4o-mini DATASET v1.0 Category: System boot optimizer ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/sysinfo.h>

#define MAX_PROCESSES 10

typedef struct {
    char name[50];
    int priority;
    int is_running;
} Process;

void print_system_info() {
    struct sysinfo info;
    sysinfo(&info);
    
    printf("System Boot Optimizer\n");
    printf("======================\n");
    printf("Uptime: %ld days, %ld hours, %ld minutes\n",
           info.uptime / 86400,
           (info.uptime % 86400) / 3600,
           (info.uptime % 3600) / 60);
    printf("Total RAM: %lu MB\n", info.totalram / (1024 * 1024));
    printf("Free RAM: %lu MB\n", info.freeram / (1024 * 1024));
    printf("Total Processes: %d\n", info.procs);
    printf("======================\n");
}

void optimize_processes(Process processes[], int count) {
    printf("Optimizing processes...\n");
    for (int i = 0; i < count; i++) {
        if (processes[i].is_running) {
            printf("Optimizing process '%s' with priority %d...\n", 
                   processes[i].name, processes[i].priority);
            sleep(1); // Simulate process optimization
            printf("Process '%s' optimized!\n", processes[i].name);
        }
    }
}

void display_processes(Process processes[], int count) {
    printf("Currently Running Processes:\n");
    printf("============================\n");
    for (int i = 0; i < count; i++) {
        printf("Process Name: %-20s | Priority: %-4d | Running: %s\n", 
               processes[i].name, 
               processes[i].priority, 
               processes[i].is_running ? "Yes" : "No");
    }
    printf("============================\n");
}

void add_process(Process processes[], int* count, const char* name, int priority) {
    if (*count < MAX_PROCESSES) {
        strcpy(processes[*count].name, name);
        processes[*count].priority = priority;
        processes[*count].is_running = 1; // Assuming all added processes are running
        (*count)++;
    } else {
        printf("Max process limit reached!\n");
    }
}

void simulate_system_load() {
    // Simulating system load
    printf("Simulating system load...\n");
    for (int i = 0; i < 5; i++) {
        printf(".");
        fflush(stdout);
        sleep(1);
    }
    printf("\nLoad simulation complete!\n");
}

int main() {
    Process processes[MAX_PROCESSES] = {0};
    int process_count = 0;

    print_system_info();

    add_process(processes, &process_count, "nginx", 1);
    add_process(processes, &process_count, "mysqld", 2);
    add_process(processes, &process_count, "sshd", 3);
    add_process(processes, &process_count, "cron", 4);
    add_process(processes, &process_count, "systemd", 5);

    display_processes(processes, process_count);
    
    simulate_system_load();
    
    optimize_processes(processes, process_count);

    return 0;
}