//GEMINI-pro DATASET v1.0 Category: Database simulation ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of records in the database
#define MAX_RECORDS 100

// Define the structure of a record
typedef struct {
    char name[50];
    int age;
    char address[100];
} record;

// Define the database
record database[MAX_RECORDS];

// Define the number of records in the database
int num_records = 0;

// Function to add a record to the database
void add_record(char *name, int age, char *address) {
    // Check if the database is full
    if (num_records == MAX_RECORDS) {
        printf("Error: Database is full\n");
        return;
    }

    // Copy the record into the database
    strcpy(database[num_records].name, name);
    database[num_records].age = age;
    strcpy(database[num_records].address, address);

    // Increment the number of records in the database
    num_records++;
}

// Function to print the database
void print_database() {
    // Iterate over the records in the database
    for (int i = 0; i < num_records; i++) {
        // Print the record
        printf("%s, %d, %s\n", database[i].name, database[i].age, database[i].address);
    }
}

// Function to search the database for a record by name
int search_database(char *name) {
    // Iterate over the records in the database
    for (int i = 0; i < num_records; i++) {
        // Check if the record matches the name
        if (strcmp(database[i].name, name) == 0) {
            // Return the index of the record
            return i;
        }
    }

    // Return -1 if the record was not found
    return -1;
}

// Function to delete a record from the database
void delete_record(char *name) {
    // Get the index of the record
    int index = search_database(name);

    // Check if the record was found
    if (index == -1) {
        printf("Error: Record not found\n");
        return;
    }

    // Shift the records after the deleted record down one
    for (int i = index; i < num_records - 1; i++) {
        database[i] = database[i + 1];
    }

    // Decrement the number of records in the database
    num_records--;
}

// Main function
int main() {
    // Add some records to the database
    add_record("John Doe", 30, "123 Main Street");
    add_record("Jane Doe", 25, "456 Elm Street");
    add_record("Bill Smith", 40, "789 Oak Street");

    // Print the database
    printf("Database:\n");
    print_database();

    // Search the database for a record
    int index = search_database("Jane Doe");

    // Check if the record was found
    if (index == -1) {
        printf("Error: Record not found\n");
    } else {
        // Print the record
        printf("Record found:\n");
        printf("%s, %d, %s\n", database[index].name, database[index].age, database[index].address);
    }

    // Delete the record from the database
    delete_record("John Doe");

    // Print the database
    printf("Database:\n");
    print_database();

    return 0;
}