//GEMINI-pro DATASET v1.0 Category: Expense Tracker ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of expenses that can be tracked
#define MAX_EXPENSES 100

// Define the structure of an expense
typedef struct {
    char description[50];
    float amount;
    int category;
} Expense;

// Define the categories of expenses
enum Category {
    FOOD,
    TRANSPORTATION,
    ENTERTAINMENT,
    OTHER
};

// Function to add an expense to the array of expenses
void add_expense(Expense expenses[], int *num_expenses, char *description, float amount, int category) {
    if (*num_expenses < MAX_EXPENSES) {
        strcpy(expenses[*num_expenses].description, description);
        expenses[*num_expenses].amount = amount;
        expenses[*num_expenses].category = category;
        (*num_expenses)++;
    } else {
        printf("Error: Maximum number of expenses reached.\n");
    }
}

// Function to print the array of expenses
void print_expenses(Expense expenses[], int num_expenses) {
    for (int i = 0; i < num_expenses; i++) {
        printf("%s %.2f %d\n", expenses[i].description, expenses[i].amount, expenses[i].category);
    }
}

// Function to calculate the total amount of expenses in a given category
float calculate_total(Expense expenses[], int num_expenses, int category) {
    float total = 0;
    for (int i = 0; i < num_expenses; i++) {
        if (expenses[i].category == category) {
            total += expenses[i].amount;
        }
    }
    return total;
}

// Main function
int main() {
    // Initialize the array of expenses
    Expense expenses[MAX_EXPENSES];

    // Initialize the number of expenses to 0
    int num_expenses = 0;

    // Add some sample expenses to the array
    add_expense(expenses, &num_expenses, "Groceries", 50.00, FOOD);
    add_expense(expenses, &num_expenses, "Gas", 20.00, TRANSPORTATION);
    add_expense(expenses, &num_expenses, "Movie tickets", 15.00, ENTERTAINMENT);
    add_expense(expenses, &num_expenses, "Other", 10.00, OTHER);

    // Print the array of expenses
    printf("Expenses:\n");
    print_expenses(expenses, num_expenses);

    // Calculate the total amount of expenses in each category
    float total_food = calculate_total(expenses, num_expenses, FOOD);
    float total_transportation = calculate_total(expenses, num_expenses, TRANSPORTATION);
    float total_entertainment = calculate_total(expenses, num_expenses, ENTERTAINMENT);
    float total_other = calculate_total(expenses, num_expenses, OTHER);

    // Print the total amount of expenses in each category
    printf("\nTotal expenses by category:\n");
    printf("Food: %.2f\n", total_food);
    printf("Transportation: %.2f\n", total_transportation);
    printf("Entertainment: %.2f\n", total_entertainment);
    printf("Other: %.2f\n", total_other);

    return 0;
}