//Gemma-7B DATASET v1.0 Category: Music Library Management System ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BOOKS 100

typedef struct Book {
    char title[50];
    char author[50];
    int quantity;
} Book;

Book books[MAX_BOOKS];

void addBook(Book book) {
    int i = 0;
    for (i = 0; books[i].title[0] != '\0'; i++) {
        if (strcmp(book.title, books[i].title) == 0) {
            books[i].quantity++;
            return;
        }
    }

    books[MAX_BOOKS - 1] = book;
    books[MAX_BOOKS - 1].quantity = 1;
}

void removeBook(char *title) {
    int i = 0;
    for (i = 0; books[i].title[0] != '\0'; i++) {
        if (strcmp(title, books[i].title) == 0) {
            books[i].quantity--;
            if (books[i].quantity == 0) {
                books[i].title[0] = '\0';
            }
            return;
        }
    }

    printf("Book not found.\n");
}

void searchBook(char *title) {
    int i = 0;
    for (i = 0; books[i].title[0] != '\0'; i++) {
        if (strcmp(title, books[i].title) == 0) {
            printf("Title: %s\n", books[i].title);
            printf("Author: %s\n", books[i].author);
            printf("Quantity: %d\n", books[i].quantity);
            return;
        }
    }

    printf("Book not found.\n");
}

int main() {
    Book book1 = {"The Lord of the Flies", "William Golding", 5};
    addBook(book1);

    Book book2 = {"To Kill a Mockingbird", "Harper Lee", 3};
    addBook(book2);

    Book book3 = {"The Great Gatsby", "F. Scott Fitzgerald", 2};
    addBook(book3);

    searchBook("The Lord of the Flies");
    removeBook("To Kill a Mockingbird");
    searchBook("To Kill a Mockingbird");

    return 0;
}