//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

int main()
{
    int sockfd, send_len, recv_len, ping_status;
    struct sockaddr_in server_addr;
    char ping_msg[] = "PING!";
    char recv_msg[1024];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_DGRAM, htons(8));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Set up the server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(8080);
    server_addr.sin_addr.s_addr = inet_addr("192.168.1.1");

    // Send the ping message
    send_len = sendto(sockfd, ping_msg, sizeof(ping_msg), 0, (struct sockaddr *)&server_addr, sizeof(server_addr));
    if (send_len < 0)
    {
        perror("Error sending ping message");
        exit(1);
    }

    // Receive the reply message
    recv_len = recvfrom(sockfd, recv_msg, sizeof(recv_msg), 0, (struct sockaddr *)&server_addr, NULL);
    if (recv_len < 0)
    {
        perror("Error receiving reply message");
        exit(1);
    }

    // Check if the ping was successful
    ping_status = strcmp(recv_msg, "PONG!");
    if (ping_status == 0)
    {
        printf("Ping successful!\n");
    }
    else
    {
        printf("Ping failed.\n");
    }

    // Close the socket
    close(sockfd);

    return 0;
}