//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/time.h>

#define BAUD 9600
#define DEVICE "/dev/ttyUSB0"
#define DELAY 100000 // 100ms

int main() {
    int fd;
    struct termios termios;

    fd = open(DEVICE, O_RDWR | O_NOCTTY | O_NDELAY);
    if (fd == -1) {
        perror("open");
        return 1;
    }

    if (tcgetattr(fd, &termios)!= 0) {
        perror("tcgetattr");
        return 1;
    }

    cfsetispeed(&termios, B9600);
    cfsetospeed(&termios, B9600);

    termios.c_cflag |= (CS8 | CREAD | CLOCAL);
    termios.c_iflag = IGNPAR;
    termios.c_oflag = 0;
    termios.c_lflag = 0;
    termios.c_cc[VMIN] = 1;
    termios.c_cc[VTIME] = DELAY / 10;

    if (tcsetattr(fd, TCSANOW, &termios)!= 0) {
        perror("tcsetattr");
        return 1;
    }

    while (1) {
        char command = 'f';
        write(fd, &command, 1);
        usleep(DELAY);
    }

    close(fd);
    return 0;
}