//GEMINI-pro DATASET v1.0 Category: User Input Sanitizer ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Our trusty magnifying glass for input inspection
int scrutinize(char *input, int maxLength) {
    // Check if the input is empty
    if (strlen(input) == 0) {
        printf("Elementary, my dear Watson! The input is empty.\n");
        return 0;
    }

    // Check if the input exceeds the maximum length
    if (strlen(input) > maxLength) {
        printf("Too much chatter, my boy! The input exceeds the maximum length.\n");
        return 0;
    }

    // Check for any suspicious characters
    for (int i = 0; i < strlen(input); i++) {
        char c = input[i];
        if (!((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9') || c == ' ')) {
            printf("Irregularities detected, Watson! The input contains suspicious characters.\n");
            return 0;
        }
    }

    // All checks passed, the input is deemed admissible
    printf("Excellent, Watson! The input appears to be in order.\n");
    return 1;
}

int main() {
    // The case begins with a mysterious message
    char message[] = "The quick brown fox jumped over the lazy dog.";

    // We must scrutinize the message for any irregularities
    int result = scrutinize(message, sizeof(message));

    // Based on our findings, we proceed with the investigation
    if (result) {
        // The message is admissible, proceed with the analysis
        printf("The message is admissible, Watson. Let us commence our analysis.\n");
    } else {
        // The message is inadmissible, further investigation is required
        printf("The message is inadmissible, Watson! We must dig deeper.\n");
    }

    return 0;
}