//Falcon-180B DATASET v1.0 Category: Movie Rating System ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_MOVIES 100
#define MAX_RATINGS 1000
#define MAX_USERS 1000

typedef struct {
    char title[50];
    int year;
    float rating;
    int num_ratings;
} Movie;

typedef struct {
    int user_id;
    int num_ratings;
    float avg_rating;
} User;

Movie movies[MAX_MOVIES];
User users[MAX_USERS];

int num_movies = 0;
int num_users = 0;

void add_movie(char* title, int year, float rating) {
    if (num_movies >= MAX_MOVIES) {
        printf("Error: Maximum number of movies reached.\n");
        return;
    }

    strcpy(movies[num_movies].title, title);
    movies[num_movies].year = year;
    movies[num_movies].rating = rating;
    movies[num_movies].num_ratings = 0;

    num_movies++;
}

void add_user(int user_id) {
    if (num_users >= MAX_USERS) {
        printf("Error: Maximum number of users reached.\n");
        return;
    }

    users[num_users].user_id = user_id;
    users[num_users].num_ratings = 0;
    users[num_users].avg_rating = 0;

    num_users++;
}

void rate_movie(int user_id, int movie_id, float rating) {
    if (user_id < 1 || user_id > num_users) {
        printf("Error: Invalid user ID.\n");
        return;
    }

    if (movie_id < 1 || movie_id > num_movies) {
        printf("Error: Invalid movie ID.\n");
        return;
    }

    movies[movie_id - 1].num_ratings++;
    movies[movie_id - 1].rating += rating;

    users[user_id - 1].num_ratings++;
    users[user_id - 1].avg_rating = (users[user_id - 1].avg_rating * (users[user_id - 1].num_ratings - 1) + rating) / users[user_id - 1].num_ratings;
}

void print_movies() {
    printf("\nMovie Ratings:\n");
    printf("--------------------\n");

    for (int i = 0; i < num_movies; i++) {
        printf("%-40s %d %.2f (%d ratings)\n", movies[i].title, movies[i].year, movies[i].rating, movies[i].num_ratings);
    }
}

void print_users() {
    printf("\nUser Ratings:\n");
    printf("--------------------\n");

    for (int i = 0; i < num_users; i++) {
        printf("%-20s %.2f (%d ratings)\n", "User", users[i].avg_rating, users[i].num_ratings);
    }
}

int main() {
    add_movie("The Shawshank Redemption", 1994, 9.3);
    add_movie("The Godfather", 1972, 9.2);
    add_movie("The Dark Knight", 2008, 9.0);

    add_user(1);
    add_user(2);
    add_user(3);

    rate_movie(1, 1, 9.5);
    rate_movie(2, 1, 10.0);
    rate_movie(3, 2, 9.0);

    print_movies();
    print_users();

    return 0;
}