//Falcon-180B DATASET v1.0 Category: Elevator Simulation ; Style: beginner-friendly
#include<stdio.h>
#include<stdlib.h>
#include<time.h>

#define MAX_FLOORS 10
#define MAX_PASSENGERS 20
#define MAX_WAIT_TIME 10

typedef struct
{
    int floor;
    int destination;
    int wait_time;
} Passenger;

Passenger passengers[MAX_PASSENGERS];
int num_passengers;

int get_random_floor()
{
    return rand() % MAX_FLOORS + 1;
}

void add_passenger()
{
    if(num_passengers < MAX_PASSENGERS)
    {
        int floor = get_random_floor();
        int destination = get_random_floor();
        int wait_time = rand() % MAX_WAIT_TIME + 1;

        passengers[num_passengers].floor = floor;
        passengers[num_passengers].destination = destination;
        passengers[num_passengers].wait_time = wait_time;
        num_passengers++;
    }
}

void print_passengers()
{
    printf("Passengers:\n");
    for(int i=0; i<num_passengers; i++)
    {
        printf("Floor %d -> Floor %d, Wait time %d\n", passengers[i].floor, passengers[i].destination, passengers[i].wait_time);
    }
}

int main()
{
    srand(time(NULL));
    num_passengers = 0;

    for(int i=0; i<MAX_PASSENGERS; i++)
    {
        add_passenger();
    }

    print_passengers();

    return 0;
}