//Falcon-180B DATASET v1.0 Category: Appointment Scheduler ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LENGTH 100

typedef struct {
    char name[MAX_LENGTH];
    char phone[MAX_LENGTH];
    char email[MAX_LENGTH];
    int date;
    int time;
    int duration;
} appointment;

void add_appointment(appointment* appts, int num_appts, char* name, char* phone, char* email, int date, int time, int duration) {
    if (num_appts >= MAX_LENGTH) {
        printf("Sorry, cannot add more appointments.\n");
        return;
    }

    strcpy(appts[num_appts].name, name);
    strcpy(appts[num_appts].phone, phone);
    strcpy(appts[num_appts].email, email);
    appts[num_appts].date = date;
    appts[num_appts].time = time;
    appts[num_appts].duration = duration;
    num_appts++;
}

void display_appointments(appointment* appts, int num_appts) {
    printf("Appointments:\n");
    for (int i = 0; i < num_appts; i++) {
        printf("Name: %s\n", appts[i].name);
        printf("Phone: %s\n", appts[i].phone);
        printf("Email: %s\n", appts[i].email);
        printf("Date: %d\n", appts[i].date);
        printf("Time: %d\n", appts[i].time);
        printf("Duration: %d minutes\n\n", appts[i].duration);
    }
}

void delete_appointment(appointment* appts, int num_appts, int index) {
    if (index >= num_appts) {
        printf("Invalid appointment index.\n");
        return;
    }

    for (int i = index; i < num_appts - 1; i++) {
        appts[i] = appts[i + 1];
    }

    num_appts--;
}

int main() {
    appointment appts[MAX_LENGTH];
    int num_appts = 0;

    add_appointment(appts, num_appts, "John Doe", "555-1234", "johndoe@example.com", 20220222, 1400, 60);
    add_appointment(appts, num_appts, "Jane Smith", "555-5678", "janesmith@example.com", 20220223, 1030, 90);

    display_appointments(appts, num_appts);

    delete_appointment(appts, num_appts, 1);

    display_appointments(appts, num_appts);

    return 0;
}