//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: excited
// Prepare for a tantalizing sorting extravaganza! Get ready to witness the magic of sorting algorithms unfold!

#include <stdio.h>
#include <stdlib.h>

// Defining an array of integers to test our sorting prowess. Oh boy, this array is filled with numbers that are itching to be organized!
int numbers[] = {38, 27, 43, 3, 9, 82, 10};

// Introducing our stellar sorting algorithms! Each one is a master of organization, ready to tame the chaos.
void bubbleSort(int arr[], int size);
void selectionSort(int arr[], int size);
void insertionSort(int arr[], int size);
void mergeSort(int arr[], int size);
void quickSort(int arr[], int size);

// A grand function that prints the sorted array with style and grace. Let's show off the elegance of the sorted numbers!
void printArray(int arr[], int size);

int main() {
  // Are you ready for the show? Get ready to see these algorithms work their magic!
  printf("Behold! The Sorting Spectacular is about to begin!\n");

  // Let's give the bubble sort algorithm a chance to shine. Watch as it gently bubbles the numbers to their rightful places!
  bubbleSort(numbers, 7);
  printf("Bubble Sort: ");
  printArray(numbers, 7);

  // Time for the selection sort to strut its stuff! See how it carefully selects the smallest number and swaps it to its rightful position.
  selectionSort(numbers, 7);
  printf("Selection Sort: ");
  printArray(numbers, 7);

  // Brace yourself for the insertion sort! It's going to insert each number into its correct spot like a master puzzle solver.
  insertionSort(numbers, 7);
  printf("Insertion Sort: ");
  printArray(numbers, 7);

  // Now, let's witness the power of divide and conquer with the merge sort! It's like a magician, splitting the array and merging it back together in sorted order.
  mergeSort(numbers, 7);
  printf("Merge Sort: ");
  printArray(numbers, 7);

  // Last but not least, the quick sort is here to amaze us with its lightning-fast partitioning and sorting skills. Get ready for some serious speed!
  quickSort(numbers, 7);
  printf("Quick Sort: ");
  printArray(numbers, 7);

  // The grand finale! Let's give these algorithms a round of applause for their splendid performance.
  printf("\nBravo! The sorting algorithms have completed their mission.");

  return 0;
}

// The legendary bubble sort algorithm! It's like watching a gentle bubble bath, slowly but surely bringing order to the numbers.
void bubbleSort(int arr[], int size) {
  int temp;
  for (int i = 0; i < size - 1; i++) {
    for (int j = 0; j < size - i - 1; j++) {
      if (arr[j] > arr[j + 1]) {
        temp = arr[j];
        arr[j] = arr[j + 1];
        arr[j + 1] = temp;
      }
    }
  }
}

// The selection sort algorithm! It's like a picky shopper, carefully selecting the smallest number from the unsorted part and swapping it to the beginning.
void selectionSort(int arr[], int size) {
  int minIndex;
  for (int i = 0; i < size - 1; i++) {
    minIndex = i;
    for (int j = i + 1; j < size; j++) {
      if (arr[j] < arr[minIndex]) {
        minIndex = j;
      }
    }
    int temp = arr[i];
    arr[i] = arr[minIndex];
    arr[minIndex] = temp;
  }
}

// The insertion sort algorithm! It's like a chef carefully inserting each ingredient into a delicious soup, ensuring that the flavors blend perfectly.
void insertionSort(int arr[], int size) {
  int key, j;
  for (int i = 1; i < size; i++) {
    key = arr[i];
    j = i - 1;
    while (j >= 0 && arr[j] > key) {
      arr[j + 1] = arr[j];
      j--;
    }
    arr[j + 1] = key;
  }
}

// The merge sort algorithm! It's like a master conductor, effortlessly combining two sorted halves into a harmonious symphony of numbers.
void mergeSort(int arr[], int size) {
  if (size <= 1) {
    return;
  }

  int mid = size / 2;

  int left[mid];
  int right[size - mid];

  for (int i = 0; i < mid; i++) {
    left[i] = arr[i];
  }

  for (int i = mid; i < size; i++) {
    right[i - mid] = arr[i];
  }

  mergeSort(left, mid);
  mergeSort(right, size - mid);

  int i = 0, j = 0, k = 0;

  while (i < mid && j < size - mid) {
    if (left[i] <= right[j]) {
      arr[k] = left[i];
      i++;
    } else {
      arr[k] = right[j];
      j++;
    }
    k++;
  }

  while (i < mid) {
    arr[k] = left[i];
    i++;
    k++;
  }

  while (j < size - mid) {
    arr[k] = right[j];
    j++;
    k++;
  }
}

// The quick sort algorithm! It's like a lightning bolt, swiftly partitioning and conquering the numbers into their rightful order.
void quickSort(int arr[], int size) {
  if (size <= 1) {
    return;
  }

  int pivot = arr[size / 2];

  int left[size];
  int right[size];

  int l = 0, r = 0;

  for (int i = 0; i < size; i++) {
    if (arr[i] < pivot) {
      left[l] = arr[i];
      l++;
    } else if (arr[i] > pivot) {
      right[r] = arr[i];
      r++;
    }
  }

  quickSort(left, l);
  quickSort(right, r);

  int i = 0;

  for (int j = 0; j < l; j++) {
    arr[i] = left[j];
    i++;
  }

  arr[i] = pivot;
  i++;

  for (int j = 0; j < r; j++) {
    arr[i] = right[j];
    i++;
  }
}

// The grand finale! Let's show off the sorted numbers in all their glory.
void printArray(int arr[], int size) {
  printf("[");
  for (int i = 0; i < size; i++) {
    printf(" %d", arr[i]);
  }
  printf(" ]\n");
}