//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#define MAX_DEVICES 100

typedef struct {
    char name[32];
    bool state;
    int type; // 0=light, 1=outlet, 2=thermostat
} device;

device devices[MAX_DEVICES];
int numDevices = 0;

void addDevice(char *name, bool state, int type) {
    strcpy(devices[numDevices].name, name);
    devices[numDevices].state = state;
    devices[numDevices].type = type;
    numDevices++;
}

void printDevices() {
    for (int i = 0; i < numDevices; i++) {
        printf("%s: %s\n", devices[i].name, devices[i].state ? "on" : "off");
    }
}

void turnOnDevice(char *name) {
    for (int i = 0; i < numDevices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = true;
            break;
        }
    }
}

void turnOffDevice(char *name) {
    for (int i = 0; i < numDevices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = false;
            break;
        }
    }
}

int main() {
    addDevice("Living Room Light", false, 0);
    addDevice("Kitchen Outlet", true, 1);
    addDevice("Bedroom Thermostat", true, 2);

    printDevices();

    turnOnDevice("Living Room Light");
    turnOffDevice("Kitchen Outlet");

    printDevices();

    return 0;
}