//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <time.h>

// Smart home devices
#define NUM_DEVICES 4
typedef enum {
    LIGHT,
    TV,
    AC,
    FAN
} device_type_t;

struct device {
    char *name;
    device_type_t type;
    bool state; // On (true) or off (false)
};

struct device devices[NUM_DEVICES] = {
    { "Living Room Light", LIGHT, false },
    { "Smart TV", TV, false },
    { "Air Conditioner", AC, false },
    { "Ceiling Fan", FAN, false }
};

// Commands
#define NUM_COMMANDS 4
typedef enum {
    TURN_ON,
    TURN_OFF,
    TOGGLE,
    STATUS
} command_type_t;

struct command {
    char *name;
    command_type_t type;
};

struct command commands[NUM_COMMANDS] = {
    { "turn on", TURN_ON },
    { "turn off", TURN_OFF },
    { "toggle", TOGGLE },
    { "status", STATUS }
};

// Custom string comparison function
bool str_equal(const char *s1, const char *s2) {
    return strcmp(s1, s2) == 0;
}

// Parse a command from a string
struct command *parse_command(const char *str) {
    for (int i = 0; i < NUM_COMMANDS; i++) {
        if (str_equal(str, commands[i].name)) {
            return &commands[i];
        }
    }
    return NULL;
}

// Get the device by name
struct device *get_device(const char *name) {
    for (int i = 0; i < NUM_DEVICES; i++) {
        if (str_equal(name, devices[i].name)) {
            return &devices[i];
        }
    }
    return NULL;
}

// Execute a command
void execute_command(struct command *command, struct device *device) {
    switch (command->type) {
    case TURN_ON:
        device->state = true;
        printf("%s is now on.\n", device->name);
        break;
    case TURN_OFF:
        device->state = false;
        printf("%s is now off.\n", device->name);
        break;
    case TOGGLE:
        device->state = !device->state;
        printf("%s is now %s.\n", device->name, device->state ? "on" : "off");
        break;
    case STATUS:
        printf("%s is %s.\n", device->name, device->state ? "on" : "off");
        break;
    }
}

// Main program
int main() {
    const char *input = "turn on living room light";

    struct command *command = parse_command(input);
    if (command == NULL) {
        fprintf(stderr, "Invalid command.\n");
        return EXIT_FAILURE;
    }

    struct device *device = get_device("Living Room Light");
    if (device == NULL) {
        fprintf(stderr, "Device not found.\n");
        return EXIT_FAILURE;
    }

    execute_command(command, device);

    return EXIT_SUCCESS;
}