//Gemma-7B DATASET v1.0 Category: Subnet Calculator ; Style: introspective
#include <stdio.h>
#include <stdlib.h>

int main()
{
    // Declare variables
    char subnetMask[16] = "255.255.255.0";
    int prefixLength = 24;
    int hostAddress = 192;

    // Calculate subnet mask in binary
    unsigned int mask = ~(~0 << (32 - prefixLength)) & 0xFFFFFFFF;
    char binaryMask[32] = "";

    // Convert mask to binary
    for (int i = 0; i < 32; i++)
    {
        if ((mask & 1) == 0)
        {
            binaryMask[i] = '0';
        }
        else
        {
            binaryMask[i] = '1';
        }
        mask >>= 1;
    }

    // Print subnet mask in binary
    printf("Subnet mask in binary: ");
    for (int i = 0; i < 32; i++)
    {
        printf("%c ", binaryMask[i]);
    }
    printf("\n");

    // Calculate usable hosts
    int usableHosts = (mask & 0xffffff) + 1;

    // Print usable hosts
    printf("Usable hosts: %d\n", usableHosts);

    // Calculate broadcast address
    int broadcastAddress = (hostAddress & mask) | (mask ^ 0xFFFFFFFF);

    // Print broadcast address
    printf("Broadcast address: %d\n", broadcastAddress);

    return 0;
}