
#include <stdio.h>
#include <stdlib.h>

int main()
{
    
    char subnetMask[16] = "255.255.255.0";
    int prefixLength = 24;
    int hostAddress = 192;

    
    unsigned int mask = ~(~0 << (32 - prefixLength)) & 0xFFFFFFFF;
    char binaryMask[32] = "";

    
    for (int i = 0; i < 32; i++)
    {
        if ((mask & 1) == 0)
        {
            binaryMask[i] = '0';
        }
        else
        {
            binaryMask[i] = '1';
        }
        mask >>= 1;
    }

    
    printf("Subnet mask in binary: ");
    for (int i = 0; i < 32; i++)
    {
        printf("%c ", binaryMask[i]);
    }
    printf("\n");

    
    int usableHosts = (mask & 0xffffff) + 1;

    
    printf("Usable hosts: %d\n", usableHosts);

    
    int broadcastAddress = (hostAddress & mask) | (mask ^ 0xFFFFFFFF);

    
    printf("Broadcast address: %d\n", broadcastAddress);

    return 0;
}