//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>

#define SHM_SIZE 1024  // Size of shared memory segment

int main() {
    // Create the shared memory segment
    int shmid = shmget(IPC_PRIVATE, SHM_SIZE, IPC_CREAT | 0666);
    if (shmid == -1) {
        perror("shmget");
        exit(1);
    }

    // Attach the shared memory segment to the current process
    void *shmaddr = shmat(shmid, NULL, 0);
    if (shmaddr == (void *)-1) {
        perror("shmat");
        exit(1);
    }

    // Create a character buffer to store the message
    char *message = (char *)shmaddr;

    // Create two child processes
    pid_t child1_pid = fork();
    if (child1_pid == -1) {
        perror("fork");
        exit(1);
    }

    if (child1_pid == 0) {  // Child process 1
        // Write a message to the shared memory segment
        sprintf(message, "Hello from child process 1!");

        // Wait for the other child process to finish
        wait(NULL);

        // Detach the shared memory segment from the current process
        shmdt(shmaddr);

        exit(0);
    }

    pid_t child2_pid = fork();
    if (child2_pid == -1) {
        perror("fork");
        exit(1);
    }

    if (child2_pid == 0) {  // Child process 2
        // Read the message from the shared memory segment
        printf("Message from child process 1: %s\n", message);

        // Detach the shared memory segment from the current process
        shmdt(shmaddr);

        exit(0);
    }

    // Wait for both child processes to finish
    waitpid(child1_pid, NULL, 0);
    waitpid(child2_pid, NULL, 0);

    // Detach the shared memory segment from the current process
    shmdt(shmaddr);

    // Remove the shared memory segment
    shmctl(shmid, IPC_RMID, NULL);

    return 0;
}