//Falcon-180B DATASET v1.0 Category: Memory management ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 1000

typedef struct {
    char *name;
    int age;
} Person;

void initialize(Person *kw) {
    kw->name = NULL;
    kw->age = 0;
}

Person *create_person() {
    Person *kw = (Person *)malloc(sizeof(Person));
    if (kw == NULL) {
        printf("Error: Memory allocation failed!\n");
        return NULL;
    }
    initialize(kw);
    return kw;
}

void set_name(Person *kw, char *name) {
    if (kw->name!= NULL) {
        free(kw->name);
    }
    kw->name = (char *)malloc(strlen(name) + 1);
    if (kw->name == NULL) {
        printf("Error: Memory allocation failed!\n");
        return;
    }
    strcpy(kw->name, name);
}

void set_age(Person *kw, int age) {
    kw->age = age;
}

void display_person(Person *kw) {
    if (kw->name == NULL) {
        printf("Name: NULL\n");
    } else {
        printf("Name: %s\n", kw->name);
    }
    printf("Age: %d\n", kw->age);
}

int main() {
    Person *kw = create_person();

    if (kw == NULL) {
        return 1;
    }

    set_name(kw, "Sir Lancelot");
    set_age(kw, 30);

    display_person(kw);

    free(kw->name);
    free(kw);

    return 0;
}