//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <sys/shm.h>
#include <sys/ipc.h>
#include <unistd.h>

int main() {
  // Create a shared memory segment
  int shmid = shmget(IPC_PRIVATE, 1024, 0666);
  if (shmid == -1) {
    perror("shmget");
    exit(1);
  }

  // Attach the shared memory segment to the current process
  void *shmptr = shmat(shmid, NULL, 0);
  if (shmptr == (void *)-1) {
    perror("shmat");
    exit(1);
  }

  // Write a message to the shared memory segment
  sprintf(shmptr, "Hello, world!");

  // Detach the shared memory segment from the current process
  shmdt(shmptr);

  // Create a child process
  int pid = fork();
  if (pid == -1) {
    perror("fork");
    exit(1);
  }

  // In the child process, read the message from the shared memory segment
  if (pid == 0) {
    void *shmptr = shmat(shmid, NULL, 0);
    if (shmptr == (void *)-1) {
      perror("shmat");
      exit(1);
    }

    printf("Message from shared memory: %s\n", shmptr);

    // Detach the shared memory segment from the child process
    shmdt(shmptr);
  }

  // In the parent process, wait for the child process to finish
  else {
    wait(NULL);

    // Delete the shared memory segment
    shmctl(shmid, IPC_RMID, NULL);
  }

  return 0;
}