//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_BYTES_PER_PACKET 2048

// Function to print the data in a packet
void print_packet(const u_char *packet, int len) {
  printf("Packet length: %d\n", len);
  int i, j;
  for (i = 0; i < len; i++) {
    printf("%02x ", packet[i]);
    if ((i + 1) % 16 == 0) {
      printf("\n");
    }
  }
  printf("\n\n");
}

// Function to handle captured packets
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
  printf("Received a packet at %s\n", ctime((const time_t *)&header->ts.tv_sec));
  print_packet(packet, header->caplen);
}

int main(int argc, char *argv[]) {
  if (argc < 2) {
    printf("Usage: %s <interface>\n", argv[0]);
    return -1;
  }

  // Open the network interface for capturing packets
  char *interface = argv[1];
  pcap_t *handle = pcap_open_live(interface, MAX_BYTES_PER_PACKET, 0, 1000, NULL);
  if (handle == NULL) {
    printf("Error opening %s for capturing packets\n", interface);
    return -1;
  }

  // Define the filter expression to capture incoming TCP packets
  struct bpf_program fp;
  if (pcap_compile(handle, &fp, "tcp", 0, 0) == -1) {
    printf("Error compiling the filter expression\n");
    return -1;
  }
  if (pcap_setfilter(handle, &fp) == -1) {
    printf("Error setting the filter\n");
    return -1;
  }

  // Start capturing packets
  pcap_loop(handle, -1, packet_handler, NULL);

  // Close the capture device
  pcap_close(handle);

  return 0;
}