//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: genious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include <pthread.h>

#define MAX_NODES 1000
#define MAX_EDGES 5000

typedef struct {
    int id;
    int degree;
    int *neighbors;
} Node;

typedef struct {
    int node1;
    int node2;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];
int num_nodes = 0;
int num_edges = 0;

void add_node(int id) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        exit(1);
    }
    nodes[num_nodes].id = id;
    nodes[num_nodes].degree = 0;
    nodes[num_nodes].neighbors = NULL;
    num_nodes++;
}

void add_edge(int node1, int node2, int weight) {
    if (num_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        exit(1);
    }
    Edge edge;
    edge.node1 = node1;
    edge.node2 = node2;
    edge.weight = weight;
    edges[num_edges] = edge;
    num_edges++;
}

void print_nodes() {
    for (int i = 0; i < num_nodes; i++) {
        printf("%d ", nodes[i].id);
    }
    printf("\n");
}

void print_edges() {
    for (int i = 0; i < num_edges; i++) {
        Edge edge = edges[i];
        printf("%d - %d (%d)\n", edge.node1, edge.node2, edge.weight);
    }
}

int main() {
    add_node(1);
    add_node(2);
    add_node(3);
    add_edge(1, 2, 10);
    add_edge(2, 3, 20);
    add_edge(3, 1, 30);
    print_nodes();
    print_edges();
    return 0;
}