
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 50

typedef struct Item{
    int id;
    char name[50];
    int quantity;
}Item;

typedef struct Warehouse{
    Item items[MAX_ITEMS];
    int count;
}Warehouse;


void addItem(Warehouse *warehouse, Item item){
    if(warehouse->count == MAX_ITEMS){
        printf("Warehouse is full\n");
        return;
    }
    
    warehouse->items[warehouse->count] = item;
    warehouse->count++;
}


void removeItem(Warehouse *warehouse, int id){
    int i, index = -1;
    
    
    for(i=0; i<warehouse->count; i++){
        if(warehouse->items[i].id == id){
            index = i;
            break;
        }
    }
    
    if(index == -1){
        printf("Item not found\n");
        return;
    }
    
    
    for(i=index+1; i<warehouse->count; i++){
        warehouse->items[i-1] = warehouse->items[i];
    }
    
    warehouse->count--;
    printf("Item removed from warehouse\n");
}


void displayItems(Warehouse warehouse){
    int i;
    
    printf("Warehouse Items:\n");
    if(warehouse.count == 0){
        printf("Empty\n");
    }
    else{
        for(i=0; i<warehouse.count; i++){
            printf("Id: %d, Name: %s, Quantity: %d\n", warehouse.items[i].id, warehouse.items[i].name, warehouse.items[i].quantity);
        }
    }
}

int main(){
    
    Warehouse wh;
    wh.count = 0;
    
    
    Item item1 = {1, "Pencil", 100};
    addItem(&wh, item1);
    
    Item item2 = {2, "Pen", 50};
    addItem(&wh, item2);
    
    Item item3 = {3, "Notebook", 200};
    addItem(&wh, item3);
    
    
    displayItems(wh);
    
    
    removeItem(&wh, 2);
    
    
    displayItems(wh);
    
    return 0;
}