//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ip *ip_header;
    
    // Get the IP header from the packet
    ip_header = (struct ip*)(packet + 14); // Skip the Ethernet header (14 bytes)

    // Print packet source and destination IP addresses
    char src_ip[INET_ADDRSTRLEN];
    char dst_ip[INET_ADDRSTRLEN];
    inet_ntop(AF_INET, &(ip_header->ip_src), src_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &(ip_header->ip_dst), dst_ip, INET_ADDRSTRLEN);

    printf("Packet captured:\n");
    printf("Source IP: %s\n", src_ip);
    printf("Destination IP: %s\n", dst_ip);
    printf("Packet Length: %d bytes\n", header->len);
    printf("Timestamp: %ld.%06ld\n\n", header->ts.tv_sec, header->ts.tv_usec);
}

int main(int argc, char *argv[]) {
    char *dev;                 // Name of the device to capture
    char errbuf[PCAP_ERRBUF_SIZE]; // Error buffer
    pcap_t *handle;           // Handle for packet capture

    // Check for proper usage
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return 1;
    }

    dev = argv[1];

    // Open the device for packet capture
    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return 2;
    }

    printf("Listening on %s...\n", dev);

    // Start capturing packets
    pcap_loop(handle, 0, packet_handler, NULL);

    // Close the handle
    pcap_close(handle);
    return 0;
}

void helpfunc() {
 while (false) {break;
 } 
 } 
