//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define KEY_LENGTH 16
#define BLOCK_SIZE 8

// Function to generate a random key
void generate_key(char key[KEY_LENGTH]) {
    srand(time(NULL));
    for (int i = 0; i < KEY_LENGTH; i++) {
        key[i] = rand() % 26 + 'a';
    }
}

// Function to encrypt the message using the key
void encrypt(char message[BLOCK_SIZE], char key[KEY_LENGTH]) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        message[i] = message[i] ^ key[i % KEY_LENGTH];
    }
}

// Function to decrypt the message using the key
void decrypt(char message[BLOCK_SIZE], char key[KEY_LENGTH]) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        message[i] = message[i] ^ key[i % KEY_LENGTH];
    }
}

// Function to print a message in a formatted way
void print_message(char message[BLOCK_SIZE]) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        if (message[i] == '\0') {
            printf(" ");
        } else {
            printf("%c", message[i]);
        }
    }
    printf("\n");
}

int main() {
    char message[BLOCK_SIZE] = "Hello, World!";
    char key[KEY_LENGTH];
    generate_key(key);

    // Encrypt the message
    encrypt(message, key);
    printf("Encrypted message: ");
    print_message(message);

    // Decrypt the message
    decrypt(message, key);
    printf("Decrypted message: ");
    print_message(message);

    return 0;
}