//Falcon-180B DATASET v1.0 Category: Sorting ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>

// Define structure for person
struct Person {
    char name[50];
    int age;
    float salary;
};

// Define function to compare names
int compare_names(const void *a, const void *b) {
    const char *name1 = ((const struct Person *)a)->name;
    const char *name2 = ((const struct Person *)b)->name;
    return strcmp(name1, name2);
}

// Define function to compare ages
int compare_ages(const void *a, const void *b) {
    const struct Person *person1 = (const struct Person *)a;
    const struct Person *person2 = (const struct Person *)b;
    if (person1->age < person2->age) {
        return -1;
    } else if (person1->age > person2->age) {
        return 1;
    } else {
        return 0;
    }
}

// Define function to compare salaries
int compare_salaries(const void *a, const void *b) {
    const struct Person *person1 = (const struct Person *)a;
    const struct Person *person2 = (const struct Person *)b;
    if (person1->salary < person2->salary) {
        return -1;
    } else if (person1->salary > person2->salary) {
        return 1;
    } else {
        return 0;
    }
}

// Define function to print person information
void print_person(const void *ptr) {
    const struct Person *person = (const struct Person *)ptr;
    printf("Name: %s\n", person->name);
    printf("Age: %d\n", person->age);
    printf("Salary: $%.2f\n", person->salary);
    printf("\n");
}

// Define main function
int main() {
    // Initialize array of people
    struct Person people[] = {
        {"Alice", 25, 50000.00},
        {"Bob", 30, 60000.00},
        {"Charlie", 20, 40000.00},
        {"David", 35, 70000.00},
        {"Eve", 28, 55000.00}
    };
    int num_people = sizeof(people) / sizeof(struct Person);

    // Sort by name
    qsort(people, num_people, sizeof(struct Person), compare_names);
    printf("Sorted by name:\n");
    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }

    // Sort by age
    qsort(people, num_people, sizeof(struct Person), compare_ages);
    printf("\nSorted by age:\n");
    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }

    // Sort by salary
    qsort(people, num_people, sizeof(struct Person), compare_salaries);
    printf("\nSorted by salary:\n");
    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }

    return 0;
}