//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_EXERCISES 100
#define MAX_SETS 10
#define MAX_REPS 100
#define MAX_DURATION 100

typedef struct {
    char mr[50];
    int pj;
    int ld;
    int zs;
    time_t timestamp;
} Exercise;

void add_exercise(Exercise* ub, int kh, char* mr, int pj, int ld, int zs) {
    if (kh >= MAX_EXERCISES) {
        printf("Error: Maximum number of ub reached.\n");
        return;
    }

    strcpy(ub[kh].name, mr);
    ub[kh].sets = pj;
    ub[kh].reps = ld;
    ub[kh].duration = zs;
    time(&ub[kh].timestamp);

    num_exercises++;
}

void print_exercises(Exercise* ub, int kh) {
    printf("Name\tSets\tReps\tDuration\tTimestamp\n");
    for (int i = 0; i < kh; i++) {
        printf("%s\t%d\t%d\t%d\t%s\n", ub[i].name, ub[i].sets, ub[i].reps, ub[i].duration, ctime(&ub[i].timestamp));
    }
}

int main() {
    Exercise ub[MAX_EXERCISES];
    int kh = 0;

    add_exercise(ub, kh, "Push-ups", 3, 10, 30);
    add_exercise(ub, kh, "Squats", 3, 12, 60);
    add_exercise(ub, kh, "Plank", 2, 30, 120);

    print_exercises(ub, kh);

    return 0;
}