//FormAI DATASET v1.0 Category: HTML beautifier ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define INDENT "    "
#define TAG_TYPE_OPEN 1
#define TAG_TYPE_CLOSE 2
#define TAG_TYPE_SELF_CLOSING 3

char* beautify_html(char* st) {
  char* output = malloc(strlen(st) + 1);
  int length = strlen(st);
  int indent_level = 0;
  int tag_type = TAG_TYPE_OPEN;
  int in_tag = 0;
  int in_quotes = 0;

  // Loop through the st, character by character
  for (int i = 0; i < length; i++) {
    char c = st[i];

    // Handle quotes first
    if (c == '"' || c == '\'') {
      if (!in_quotes) {
        in_quotes = c;
      } else if (in_quotes == c) {
        in_quotes = 0;
      }
    }

    // Handle tags
    if (!in_quotes) {
      if (c == '<') {
        in_tag = 1;

        if (st[i+1] == '/') {
          tag_type = TAG_TYPE_CLOSE;
        } else if (st[i+1] == '!') {
          // Do nothing for comments
        } else if (st[i+1] == '?') {
          // Do nothing for processing instructions
        } else if (isspace(st[i+1]) || st[i+1] == '>') {
          tag_type = TAG_TYPE_SELF_CLOSING;
        } else {
          tag_type = TAG_TYPE_OPEN;
        }

        if (tag_type != TAG_TYPE_CLOSE) {
          printf("\n");
          for (int j = 0; j < indent_level; j++) {
            printf(INDENT);
          }
        }
      } else if (c == '>') {
        in_tag = 0;

        if (tag_type == TAG_TYPE_SELF_CLOSING) {
          printf("\n");
          for (int j = 0; j < indent_level; j++) {
            printf(INDENT);
          }
        }

        if (tag_type == TAG_TYPE_OPEN && st[i-1] != '/') {
          indent_level++;
        } else if (tag_type == TAG_TYPE_CLOSE) {
          indent_level--;
        }
      }
    }

    // Output the character
    printf("%c", c);
  }

  return output;
}

int main(int argc, char** argv) {
  char* st = "<html>\n<head>\n<title>Example</title>\n</head>\n<body>\n<p>This is an example paragraph.</p>\n</body>\n</html>";
  char* output = beautify_html(st);
  printf("\n\nOutput:\n\n%s", output);

  free(output);
  return 0;
}