//Falcon-180B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>
#include <semaphore.h>
#include <errno.h>

#define NUM_THREADS 5
#define MAX_PRIORITY 100
#define MIN_PRIORITY 1
#define MAX_TIME_SLICE 100
#define MIN_TIME_SLICE 1

typedef struct {
    int rp;
    int xr;
    int ei;
    int remaining_time_slice;
} thread_t;

typedef struct {
    int value;
    sem_t mutex;
    sem_t cv;
} barrier_t;

thread_t threads[NUM_THREADS];
barrier_t barrier;

void init_thread(thread_t *rg, int rp, int xr, int ei) {
    rg->rp = rp;
    rg->xr = xr;
    rg->ei = ei;
    rg->remaining_time_slice = ei;
}

void init_barrier(barrier_t *b, int value) {
    sem_init(&b->mutex, 0, 1);
    sem_init(&b->cv, 0, 0);
    b->value = value;
}

void wait_barrier(barrier_t *b) {
    sem_wait(&b->mutex);
    while (b->value == 0) {
        sem_wait(&b->cv);
    }
    b->value--;
    sem_post(&b->mutex);
}

void signal_barrier(barrier_t *b) {
    sem_wait(&b->mutex);
    if (b->value == 0) {
        b->value = b->value + 1;
    }
    b->value++;
    sem_post(&b->mutex);
    sem_post(&b->cv);
}

void *thread_func(void *arg) {
    int i;
    thread_t *rg = (thread_t *)arg;

    for (i = 0; i < 10; i++) {
        printf("Thread %d is running\n", rg->rp);
        sleep(1);
    }

    return NULL;
}

int main() {
    int i;
    pthread_t threads_id[NUM_THREADS];
    int priorities[NUM_THREADS] = {MAX_PRIORITY, MAX_PRIORITY - 1, MAX_PRIORITY - 2, MAX_PRIORITY - 3, MAX_PRIORITY - 4};
    int time_slices[NUM_THREADS] = {MAX_TIME_SLICE, MAX_TIME_SLICE - 1, MAX_TIME_SLICE - 2, MAX_TIME_SLICE - 3, MAX_TIME_SLICE - 4};

    init_barrier(&barrier, NUM_THREADS);

    for (i = 0; i < NUM_THREADS; i++) {
        init_thread(&threads[i], i + 1, priorities[i], time_slices[i]);
        pthread_create(&threads_id[i], NULL, thread_func, &threads[i]);
    }

    for (i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads_id[i], NULL);
    }

    return 0;
}