
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>


#define MAX_NETWORKS 10


typedef struct {
    char ssid[32];
    int signal_strength;
} wifi_network_t;


int compare_networks(const void *a, const void *b) {
    const wifi_network_t *network_a = (const wifi_network_t *)a;
    const wifi_network_t *network_b = (const wifi_network_t *)b;

    if (network_a->signal_strength > network_b->signal_strength) {
        return -1;
    } else if (network_a->signal_strength < network_b->signal_strength) {
        return 1;
    } else {
        return 0;
    }
}


void print_networks(wifi_network_t *networks, int num_networks) {
    qsort(networks, num_networks, sizeof(wifi_network_t), compare_networks);

    for (int i = 0; i < num_networks; i++) {
        printf("%d. %s (%d)\n", i + 1, networks[i].ssid, networks[i].signal_strength);
    }
}


int get_networks(wifi_network_t *networks) {
    
    return 0;
}

int main() {
    wifi_network_t networks[MAX_NETWORKS];

    int num_networks = get_networks(networks);

    if (num_networks > 0) {
        print_networks(networks, num_networks);
    } else {
        printf("No Wi-Fi networks found.\n");
    }

    return 0;
}