
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LENGTH 50
#define MAX_QUANTITY 1000

typedef struct {
    char name[MAX_NAME_LENGTH];
    int quantity;
} Product;

void addProduct(Product* products, int numProducts, char* name, int quantity) {
    for (int i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            products[i].quantity += quantity;
            return;
        }
    }
    strcpy(products[numProducts].name, name);
    products[numProducts].quantity = quantity;
    numProducts++;
}

void removeProduct(Product* products, int numProducts, char* name) {
    for (int i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            products[i].quantity = 0;
            return;
        }
    }
}

void displayProducts(Product* products, int numProducts) {
    printf("Product Inventory:\n");
    for (int i = 0; i < numProducts; i++) {
        if (products[i].quantity > 0) {
            printf("%s: %d\n", products[i].name, products[i].quantity);
        }
    }
}

int main() {
    Product products[MAX_PRODUCTS];
    int numProducts = 0;

    addProduct(products, numProducts, "Apples", 50);
    addProduct(products, numProducts, "Oranges", 25);

    displayProducts(products, numProducts);

    removeProduct(products, numProducts, "Apples");

    displayProducts(products, numProducts);

    return 0;
}