
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>
#include <curl/easy.h>

#define BUFFER_SIZE 1024

struct ftp_data {
    CURL *curl;
    FILE *fp;
    char filename[256];
    char buffer[BUFFER_SIZE];
};

size_t write_data(void *ptr, size_t size, size_t nmemb, void *userp) {
    struct ftp_data *data = (struct ftp_data *) userp;
    size_t realsize = size * nmemb;
    memcpy(data->buffer, ptr, realsize);
    fwrite(data->buffer, 1, realsize, data->fp);
    return realsize;
}

int progress_callback(void *clientp, curl_off_t dltotal, curl_off_t dlnow, curl_off_t ultotal, curl_off_t ulnow) {
    printf("Total bytes: %ld\n", dltotal);
    printf("Downloaded bytes: %ld\n", dlnow);
    printf("Uploaded bytes: %ld\n", ulnow);
    return 0;
}

int main(int argc, char *argv[]) {
    CURL *curl;
    CURLcode res;
    struct ftp_data data;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        data.curl = curl;
        data.fp = stdout;
        curl_easy_setopt(curl, CURLOPT_URL, "ftp:
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &data);
        curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 0L);
        curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION, progress_callback);
        res = curl_easy_perform(curl);

        if(res!= CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(res));
        }

        curl_easy_cleanup(curl);
        curl_global_cleanup();
    }

    return 0;
}