//Falcon2-11B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Define the structure of a vehicle
struct Vehicle {
    char name[20];
    int max_speed;
    int current_speed;
    int direction;
};

// Define the function to initialize a vehicle
void initialize_vehicle(struct Vehicle *v, char name[20], int max_speed, int current_speed, int direction) {
    strcpy(v->name, name);
    v->max_speed = max_speed;
    v->current_speed = current_speed;
    v->direction = direction;
}

// Define the function to update the vehicle's speed
void update_speed(struct Vehicle *v, int new_speed) {
    v->current_speed = new_speed;
}

// Define the function to control the vehicle's direction
void control_direction(struct Vehicle *v, int new_direction) {
    v->direction = new_direction;
}

// Define the function to print the vehicle's status
void print_status(struct Vehicle *v) {
    printf("Vehicle Name: %s\n", v->name);
    printf("Max Speed: %d\n", v->max_speed);
    printf("Current Speed: %d\n", v->current_speed);
    printf("Direction: %d\n", v->direction);
}

int main() {
    // Create a vehicle object
    struct Vehicle car;
    initialize_vehicle(&car, "Car", 100, 0, 0);

    // Print the initial status of the vehicle
    printf("Initial Status:\n");
    print_status(&car);

    // Update the vehicle's speed to 60
    update_speed(&car, 60);

    // Print the updated status of the vehicle
    printf("Updated Status:\n");
    print_status(&car);

    // Control the vehicle's direction to go forward
    control_direction(&car, 1);

    // Print the updated status of the vehicle
    printf("Updated Status:\n");
    print_status(&car);

    // Control the vehicle's direction to go backward
    control_direction(&car, -1);

    // Print the updated status of the vehicle
    printf("Updated Status:\n");
    print_status(&car);

    // Control the vehicle's speed to 80
    update_speed(&car, 80);

    // Print the updated status of the vehicle
    printf("Updated Status:\n");
    print_status(&car);

    return 0;
}