
#include <stdio.h>
#include <stdlib.h>
#include <time.h>


#define MAP_WIDTH 10
#define MAP_HEIGHT 10


#define NUM_ITEMS 5


#define ITEM_HEALTH 0
#define ITEM_WEAPONS 1
#define ITEM_ARMOR 2


#define ITEM_HEALTH_BONUS 10
#define ITEM_WEAPON_DAMAGE 5
#define ITEM_ARMOR_BONUS 2


int map[MAP_WIDTH][MAP_HEIGHT];


struct item {
    int type;
    int quantity;
    int x;
    int y;
};

struct item items[NUM_ITEMS];


void generate_map() {
    for (int x = 0; x < MAP_WIDTH; x++) {
        for (int y = 0; y < MAP_HEIGHT; y++) {
            map[x][y] = rand() % 3;
        }
    }
}


void place_items() {
    for (int i = 0; i < NUM_ITEMS; i++) {
        items[i].type = rand() % 3;
        items[i].quantity = rand() % 5 + 1;
        items[i].x = rand() % MAP_WIDTH;
        items[i].y = rand() % MAP_HEIGHT;
    }
}


void print_map() {
    for (int x = 0; x < MAP_WIDTH; x++) {
        for (int y = 0; y < MAP_HEIGHT; y++) {
            printf("%d ", map[x][y]);
        }
        printf("\n");
    }
}

int main() {
    
    srand(time(NULL));

    
    generate_map();

    
    place_items();

    
    print_map();

    return 0;
}