
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define PORT 8080
#define BUFFSIZE 1024
#define MSG_SIZE 500
#define MAX_CLIENTS 10


int numClients = 0;
int portno;
struct sockaddr_in serv_addr;
char buffer[BUFFSIZE];

int main()
{
    int listenSocketFD, connSocketFD, n;
    struct sockaddr_in serv_addr;
    struct sockaddr_in client_addr;
    int addrlen = sizeof(client_addr);

    
    listenSocketFD = socket(AF_INET, SOCK_STREAM, 0);
    if (listenSocketFD < 0)
    {
        perror("ERROR opening socket");
        exit(EXIT_FAILURE);
    }

    
    int optval = 1;
    if (setsockopt(listenSocketFD, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval)))
    {
        perror("ERROR setting socket option");
        exit(EXIT_FAILURE);
    }

    
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    
    if (bind(listenSocketFD, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
    {
        perror("ERROR on binding");
        exit(EXIT_FAILURE);
    }

    
    listen(listenSocketFD, MAX_CLIENTS);

    while (numClients < MAX_CLIENTS)
    {
        
        connSocketFD = accept(listenSocketFD, (struct sockaddr *)&client_addr, &addrlen);
        if (connSocketFD < 0)
        {
            perror("ERROR on accept");
            exit(EXIT_FAILURE);
        }

        
        numClients++;

        
        n = read(connSocketFD, buffer, BUFFSIZE);
        if (n < 0)
        {
            perror("ERROR reading from socket");
            exit(EXIT_FAILURE);
        }

        
        printf("%s\n", buffer);

        
        close(connSocketFD);
    }

    
    close(listenSocketFD);

    return 0;
}