//GEMINI-pro DATASET v1.0 Category: Client Server Application ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// Recursively check if the given string is a palindrome
int is_palindrome(char *str, int start, int end) {
    // If the start index is greater than the end index, the string is a palindrome
    if (start >= end) {
        return 1;
    }
    // If the first and last characters are different, the string is not a palindrome
    else if (str[start] != str[end]) {
        return 0;
    }
    // Recursively check the remaining substring
    else {
        return is_palindrome(str, start + 1, end - 1);
    }
}

int main() {
    // Create a socket for the server
    int server_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (server_socket == -1) {
        perror("Could not create server socket");
        exit(1);
    }

    // Bind the socket to a specific address and port
    struct sockaddr_in server_address;
    memset(&server_address, 0, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = htonl(INADDR_ANY);
    server_address.sin_port = htons(8080);
    if (bind(server_socket, (struct sockaddr *) &server_address, sizeof(server_address)) == -1) {
        perror("Could not bind server socket");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(server_socket, 5) == -1) {
        perror("Could not listen for incoming connections");
        exit(1);
    }

    // Accept an incoming connection
    int client_socket = accept(server_socket, NULL, NULL);
    if (client_socket == -1) {
        perror("Could not accept incoming connection");
        exit(1);
    }

    // Receive the message from the client
    char buffer[1024];
    memset(buffer, 0, sizeof(buffer));
    if (recv(client_socket, buffer, sizeof(buffer), 0) == -1) {
        perror("Could not receive message from client");
        exit(1);
    }

    // Check if the message is a palindrome
    int palindrome = is_palindrome(buffer, 0, strlen(buffer) - 1);

    // Send the result back to the client
    if (send(client_socket, &palindrome, sizeof(palindrome), 0) == -1) {
        perror("Could not send result to client");
        exit(1);
    }

    // Close the client socket
    close(client_socket);

    // Close the server socket
    close(server_socket);

    return 0;
}