//Code Llama-13B DATASET v1.0 Category: Interprocess communication ; Style: happy
// IPC_example.c
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <unistd.h>

// Define the message structure
struct msgbuf {
    long mtype;
    char mtext[100];
};

int main(void) {
    key_t key;
    int msgid;
    struct msgbuf buf;

    // Create a unique key
    key = ftok("msgqueue", 65);
    if (key == -1) {
        perror("ftok");
        exit(1);
    }

    // Create a message queue
    msgid = msgget(key, 0666 | IPC_CREAT);
    if (msgid == -1) {
        perror("msgget");
        exit(1);
    }

    // Send a message
    buf.mtype = 1;
    strcpy(buf.mtext, "Hello, world!");
    if (msgsnd(msgid, &buf, sizeof(buf), 0) == -1) {
        perror("msgsnd");
        exit(1);
    }

    // Receive a message
    if (msgrcv(msgid, &buf, sizeof(buf), 0, 0) == -1) {
        perror("msgrcv");
        exit(1);
    }

    printf("Received message: %s\n", buf.mtext);

    // Clean up
    msgctl(msgid, IPC_RMID, NULL);

    return 0;
}