//Gemma-7B DATASET v1.0 Category: Tic Tac Toe AI ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>

#define BOARD_SIZE 3
#define EMPTY_SPOT -1

int main()
{
    int board[BOARD_SIZE][BOARD_SIZE] = {{EMPTY_SPOT, EMPTY_SPOT, EMPTY_SPOT},
                                 {EMPTY_SPOT, EMPTY_SPOT, EMPTY_SPOT},
                                 {EMPTY_SPOT, EMPTY_SPOT, EMPTY_SPOT}};

    int current_player = 1;
    int game_won = 0;

    // Game loop
    while (!game_won && board[2][2] != EMPTY_SPOT)
    {
        // Get the player's move
        int move_x, move_y;
        printf("Enter your move (x, y): ");
        scanf("%d %d", &move_x, &move_y);

        // Validate the move
        if (move_x < 0 || move_x >= BOARD_SIZE || move_y < 0 || move_y >= BOARD_SIZE)
        {
            printf("Invalid move.\n");
            continue;
        }

        // If the spot is not empty, try again
        if (board[move_x][move_y] != EMPTY_SPOT)
        {
            printf("That spot is already taken.\n");
            continue;
        }

        // Place the player's mark on the board
        board[move_x][move_y] = current_player;

        // Check if the player has won
        game_won = check_win(board, current_player);

        // Switch to the next player
        current_player *= -1;
    }

    // Game over
    if (game_won)
    {
        printf("Congratulations, you won!\n");
    }
    else
    {
        printf("It's a draw.\n");
    }

    return 0;
}

int check_win(int **board, int player)
{
    // Check rows
    for (int i = 0; i < BOARD_SIZE; i++)
    {
        if (board[0][i] == board[1][i] && board[0][i] == board[2][i] && board[0][i] == player)
        {
            return 1;
        }
    }

    // Check columns
    for (int j = 0; j < BOARD_SIZE; j++)
    {
        if (board[j][0] == board[j][1] && board[j][0] == board[j][2] && board[j][0] == player)
        {
            return 1;
        }
    }

    // Check diagonals
    if (board[0][0] == board[1][1] && board[0][0] == board[2][2] && board[0][0] == player)
    {
        return 1;
    }

    // No win
    return 0;
}